	var saldo = document.getElementById('saldo');
		saldo.addEventListener('keyup', function(e){
			// tambahkan 'Rp.' pada saat form di ketik
			// gunakan fungsi formatRupiah() untuk mengubah angka yang di ketik menjadi format angka
			saldo.value = formatSaldo(this.value, 'Rp. ');
		});
 
		/* Fungsi formatRupiah */
		function formatSaldo(angka, prefix){
			var number_string = angka.replace(/[^,\d]/g, '').toString(),
			split   		= number_string.split(','),
			sisa     		= split[0].length % 3,
			saldo     		= split[0].substr(0, sisa),
			ribuan     		= split[0].substr(sisa).match(/\d{3}/gi);
 
			// tambahkan titik jika yang di input sudah menjadi angka ribuan
			if(ribuan){
				separator = sisa ? '.' : '';
				saldo += separator + ribuan.join('.');
			}
 
			saldo = split[1] != undefined ? saldo + ',' + split[1] : saldo;
			return prefix == undefined ? saldo : (saldo ? 'Rp. ' + saldo : '');
		}